/** SKYSEVEN MANAGER - ULTIMATE (FIXED) */
const API_URL = 'api.php'; 
const BASE_URL = window.location.origin + window.location.pathname.replace('index.html', ''); 
const ADMIN_PIN = "6359"; // PIN RAHASIA

// --- KONFIGURASI STUDIO ---
const STUDIOS = {
    1: { name: "Studio 1", bgOptions: ["Gray", "White", "Beige", "Baby Blue", "Yellow", "Red", "Curtain Red", "Landscape Red", "90s Yearbook"] },
    2: { name: "Studio 2", bgOptions: ["Blue", "Pink", "80s Year Book", "Baby Blue", "Beige", "Gray", "White", "Landscape Light Gray"] },
    3: { name: "Aquarium", bgOptions: ["Aquarium"] } 
};
const DURATIONS = { portrait: 15, landscape: 25, aquarium: 10, prep: 5 };
const INDO_MONTHS = { 'januari':0, 'februari':1, 'maret':2, 'april':3, 'mei':4, 'juni':5, 'juli':6, 'agustus':7, 'september':8, 'oktober':9, 'november':10, 'desember':11 };

let appState = { 
    user: "Admin", 
    sessions: [], 
    processedSessions: [], 
    monitorSessionId: null, 
    alarmEnabled: localStorage.getItem('alarm_enabled') !== 'false', 
    currentQRLink: '' 
};

let audioCtx; 
function initAudio() { if (!audioCtx) audioCtx = new (window.AudioContext || window.webkitAudioContext)(); }

// ================= SECURITY LOGIC (PIN SYSTEM) =================
window.verifyPin = function() {
    const input = document.getElementById('admin-pin');
    const screen = document.getElementById('login-screen');
    
    if (input.value === ADMIN_PIN) {
        // PIN BENAR
        localStorage.setItem('skyseven_auth', 'true'); 
        if(screen) screen.classList.add('hidden'); // Sembunyikan layar kunci
        
        Swal.fire({
            icon: 'success', 
            title: 'Berhasil Masuk', 
            toast: true,
            position: 'top',
            timer: 1500, 
            showConfirmButton: false, 
            background: '#1e293b', 
            color: '#fff'
        });
    } else {
        // PIN SALAH
        Swal.fire({
            icon: 'error', 
            title: 'PIN Salah!', 
            text: 'Akses ditolak.', 
            background: '#1e293b', 
            color: '#fff',
            confirmButtonColor: '#f87171'
        });
        input.value = ''; // Reset input
        input.focus();
    }
};

// ================= DATA HANDLER (FETCH & IMPORT) =================
async function fetchSessions() {
    try {
        const response = await fetch(`${API_URL}?action=get_sessions`);
        const data = await response.json();
        if (Array.isArray(data)) {
            appState.sessions = data.map(s => ({
                id: parseInt(s.id), 
                studio_id: parseInt(s.studio_id), 
                customer_name: s.customer_name, 
                background: s.background,
                start_time: parseFloat(s.start_time), 
                end_time: parseFloat(s.end_time), 
                duration: parseInt(s.duration)
            }));
            if(typeof refreshData === "function") refreshData();
        }
    } catch (error) { console.error("Error Fetch:", error); }
}

async function handleSmartImport() {
    const rawText = document.getElementById('import-area').value;
    if (!rawText.trim()) return Swal.fire('Error', 'Paste data invoice!', 'warning');
    Swal.fire({ title: 'Menganalisa...', timer: 800, didOpen: () => Swal.showLoading() });
    
    setTimeout(async () => {
        const extractedData = parseKuyStudioText(rawText);
        if (extractedData.length === 0) return Swal.fire('Gagal', 'Data tidak dikenali.', 'error');
        
        const confirm = await Swal.fire({ title: `${extractedData.length} Data Ditemukan`, icon: 'info', showCancelButton: true, confirmButtonText: 'Simpan', confirmButtonColor: '#22c55e', background: '#1e293b', color:'#fff' });
        
        if (confirm.isConfirmed) {
            Swal.fire({ title: 'Menyimpan...', didOpen: () => Swal.showLoading() });
            for (const data of extractedData) { await fetch(`${API_URL}?action=add_session`, { method: 'POST', body: JSON.stringify(data) }); }
            fetchSessions(); 
            window.toggleImport(false); 
            document.getElementById('import-area').value = '';
            Swal.fire({ icon: 'success', title: 'Selesai', timer: 1000, showConfirmButton: false });
        }
    }, 600);
}

function parseKuyStudioText(text) {
    const results = []; const blocks = text.split(/(?=INV\d+)/g); 
    blocks.forEach(block => {
        if (block.length < 20) return; 
        let studioId = 1; if (/Self Photo Studio 2/i.test(block)) studioId = 2; else if (/Photobox/i.test(block)) studioId = 3; 
        const bgMatch = block.match(/Background\s*:\s*([^\n\r\t]+)/i); 
        let bg = bgMatch ? bgMatch[1].trim() : (studioId == 3 ? "Aquarium" : "Gray"); 
        bg = bg.replace(/BNI|QRIS|BRI|PAID|Free Soft File/gi, '').trim(); 
        let name = "Unknown"; const viewLocIndex = block.indexOf("View location"); 
        if (viewLocIndex !== -1) { const textAfter = block.substring(viewLocIndex + 13); const lines = textAfter.split(/\r?\n/).map(l => l.trim()).filter(l => l !== ""); if(lines.length > 0) name = lines[0]; }
        const dateMatch = block.match(/(Senin|Selasa|Rabu|Kamis|Jumat|Sabtu|Minggu),\s+(\d+)\s+(\w+)\s+(\d{4})\s+(\d{2}:\d{2})/i);
        if (dateMatch) {
            const day = parseInt(dateMatch[2]); const month = INDO_MONTHS[dateMatch[3].toLowerCase()]||0; const year = parseInt(dateMatch[4]); const [hrs, mins] = dateMatch[5].split(':').map(Number);
            const startTime = new Date(year, month, day, hrs, mins, 0, 0).getTime();
            let dur = (studioId == 3) ? DURATIONS.aquarium : (bg.toLowerCase().includes('landscape') ? DURATIONS.landscape : DURATIONS.portrait);
            results.push({ studio_id: studioId, customer_name: name, background: bg, start_time: startTime, end_time: startTime + ((dur + DURATIONS.prep) * 60 * 1000), duration: dur + DURATIONS.prep });
        }
    }); return results;
}
// ================= MANUAL INPUT & EDIT LOGIC =================

window.handleSubmitSession = async function(e) { 
    e.preventDefault(); 
    const name=document.getElementById('inp-name').value; 
    const studioEl=document.querySelector('input[name="studio_select"]:checked'); 
    const bg=document.getElementById('inp-bg').value; 
    const dateVal=document.getElementById('inp-date').value; 
    const timeVal=document.getElementById('inp-time').value; 
    
    if(!name||!studioEl)return; 
    
    const [y,m,d]=dateVal.split('-'); const [hr,mn]=timeVal.split(':'); 
    const start=new Date(y,m-1,d,hr,mn).getTime(); 
    
    // Hitung Durasi Otomatis
    let dur=(studioEl.value==3)?DURATIONS.aquarium:(bg.toLowerCase().includes('landscape')?DURATIONS.landscape:DURATIONS.portrait); 
    const totalDur=dur+DURATIONS.prep; 
    const end=start+(totalDur*60*1000); 
    
    await fetch(`${API_URL}?action=add_session`, {
        method:'POST', 
        body:JSON.stringify({studio_id:studioEl.value, customer_name:name, background:bg, start_time:start, end_time:end, duration:totalDur})
    }); 
    
    fetchSessions(); window.toggleModal(false); e.target.reset(); 
    Swal.fire({icon:'success',title:'Saved',timer:1000,showConfirmButton:false}); 
};

window.updateBgOptions = function(selectId='inp-bg', radioName='studio_select') { 
    const el=document.querySelector(`input[name="${radioName}"]:checked`); if(!el)return; 
    const sel=document.getElementById(selectId); sel.innerHTML=''; 
    STUDIOS[el.value].bgOptions.forEach(bg=>{
        const opt=document.createElement('option');
        opt.value=bg; opt.innerText=bg; sel.appendChild(opt)
    }); 
};

window.openEditFromMonitor = function() { 
    if(!appState.monitorSessionId) return; 
    window.toggleMonitor(false); 
    window.openEditModal(appState.monitorSessionId); 
};

window.openEditModal = function(id) {
    const session = appState.sessions.find(s => s.id == id); if(!session) return;
    
    document.getElementById('edit-id').value = session.id; 
    document.getElementById('edit-name').value = session.customer_name;
    document.getElementsByName('edit_studio').forEach(r => { r.checked = (r.value == session.studio_id); });
    window.updateBgOptions('edit-bg', 'edit_studio'); 
    document.getElementById('edit-bg').value = session.background;
    
    const d = new Date(session.start_time); 
    // Format YYYY-MM-DD untuk input date HTML5
    const yyyy = d.getFullYear();
    const mm = String(d.getMonth() + 1).padStart(2, '0');
    const dd = String(d.getDate()).padStart(2, '0');
    const hh = String(d.getHours()).padStart(2, '0');
    const min = String(d.getMinutes()).padStart(2, '0');

    document.getElementById('edit-date').value = `${yyyy}-${mm}-${dd}`;
    document.getElementById('edit-time').value = `${hh}:${min}`;
    
    window.toggleEditModal(true);
};

window.handleSaveEdit = async function(e) { 
    e.preventDefault(); 
    const id = document.getElementById('edit-id').value; 
    const name = document.getElementById('edit-name').value; 
    const studioEl = document.querySelector('input[name="edit_studio"]:checked'); 
    const bg = document.getElementById('edit-bg').value; 
    const dateVal = document.getElementById('edit-date').value; 
    const timeVal = document.getElementById('edit-time').value; 

    if(!name || !dateVal || !timeVal || !studioEl) return; 

    const [y,m,d] = dateVal.split('-'); const [hr,mn] = timeVal.split(':'); 
    const start = new Date(y, m-1, d, hr, mn).getTime(); 
    
    let dur = (studioEl.value == 3) ? DURATIONS.aquarium : (bg.toLowerCase().includes('landscape') ? DURATIONS.landscape : DURATIONS.portrait); 
    const totalDur = dur + DURATIONS.prep; 
    const end = start + (totalDur * 60 * 1000); 

    await fetch(`${API_URL}?action=update_session`, {
        method: 'POST', 
        body: JSON.stringify({id, studio_id: studioEl.value, customer_name: name, background: bg, start_time: start, end_time: end, duration: totalDur})
    }); 
    
    fetchSessions(); window.toggleEditModal(false); 
    if(appState.monitorSessionId == id) window.openMonitor(id); 
    Swal.fire({icon: 'success', title: 'Data Diupdate', timer: 1000, showConfirmButton: false}); 
};

window.handleDeleteSession = async function() { 
    const id = document.getElementById('edit-id').value; 
    const c = await Swal.fire({
        title: 'Hapus Sesi?', text: "Data akan hilang permanen.", icon: 'warning', 
        showCancelButton: true, confirmButtonColor: '#f87171', cancelButtonColor: '#334155', 
        confirmButtonText: 'Ya, Hapus', background: '#1e293b', color:'#fff'
    }); 
    
    if(c.isConfirmed){ 
        await fetch(`${API_URL}?action=delete_session`, {method: 'POST', body: JSON.stringify({id})}); 
        fetchSessions(); window.toggleEditModal(false); window.toggleMonitor(false); 
        Swal.fire({icon: 'success', title: 'Terhapus', timer: 1000, showConfirmButton: false}); 
    } 
};

// ================= QR CODE =================
window.showCustomerQR = async function(id, event) {
    if(event) event.stopPropagation(); 
    try {
        const res = await fetch(`${API_URL}?action=generate_token`, { method: 'POST', body: JSON.stringify({id}) });
        const json = await res.json();
        
        if(json.status === 'success') {
            const link = `${BASE_URL}customer.html?token=${json.data.uuid}`;
            appState.currentQRLink = link;
            document.getElementById('qrcode-container').innerHTML = '';
            new QRCode(document.getElementById("qrcode-container"), { text: link, width: 180, height: 180 });
            window.toggleQR(true);
        }
    } catch(err) { console.error(err); Swal.fire('Error', 'Gagal generate QR', 'error'); }
};

window.copyLink = function() {
    navigator.clipboard.writeText(appState.currentQRLink).then(() => {
        document.getElementById('btn-copy-link').innerText = "COPIED!";
        setTimeout(() => document.getElementById('btn-copy-link').innerText = "COPY LINK", 2000);
    });
};
window.toggleQR = (s) => document.getElementById('modal-qr').classList.toggle('hidden', !s);


// ================= RENDERING ENGINE (GRID & PROGRESS) =================

function refreshData() {
    appState.processedSessions = processSessions(appState.sessions);
    renderGrid(); 
    renderTable(); // Akan ada di Part 3
    renderHistory(); // Akan ada di Part 3
    if (appState.monitorSessionId) renderFullScreen();
}

// LOGIKA BADGE COUNTER (1/2, 2/2)
function processSessions(rawData) {
    let list = rawData.sort((a,b) => a.start_time - b.start_time);
    const nameCounts = {}; const nameCurrent = {};
    
    // Hitung total booking per nama di hari yang sama
    list.forEach(s => {
        const dKey = new Date(s.start_time).toDateString();
        const key = `${dKey}_${s.customer_name.toLowerCase().trim()}`;
        nameCounts[key] = (nameCounts[key] || 0) + 1;
    });

    return list.map(s => {
        const dKey = new Date(s.start_time).toDateString();
        const key = `${dKey}_${s.customer_name.toLowerCase().trim()}`;
        if (!nameCurrent[key]) nameCurrent[key] = 0; 
        nameCurrent[key]++;
        
        let badge = "";
        if (nameCounts[key] > 1) badge = `${nameCurrent[key]}/${nameCounts[key]}`;
        return { ...s, display_badge: badge };
    });
}

// RENDER GRID DENGAN PROGRESS BAR
function renderGrid() {
    const container = document.getElementById('studio-grid-container'); if(!container) return;
    const now = Date.now();
    
    // Filter: Hanya tampilkan yang BELUM SELESAI di Grid
    const active = appState.processedSessions.filter(s => now < s.end_time);
    const list = active.slice(0, 3); // Max 3
    
    document.getElementById('grid-date-display').innerText = (list.length > 0) ? "LIVE & UPCOMING" : "NO ACTIVE SESSION";
    
    if (list.length === 0) { 
        container.innerHTML = ""; 
        document.getElementById('grid-empty-state').classList.replace('hidden','flex'); 
        return; 
    } 
    document.getElementById('grid-empty-state').classList.replace('flex','hidden');

    container.innerHTML = list.map(s => {
        const prepEnd = s.start_time + (DURATIONS.prep * 60 * 1000);
        const total = s.end_time - s.start_time; 
        const elapsed = now - s.start_time;
        
        // Logic Progress Bar
        let pct = 0;
        let ui = { badge:"WAIT", cls:"bg-white/5 text-textmuted border-white/10", timer:"-", tCls:"text-textmuted", ind:"bg-textmuted" };
        
        if (now >= s.start_time && now < s.end_time) {
            pct = Math.min((elapsed/total)*100, 100); // Hitung %
            
            if (now < prepEnd) { 
                ui.badge = "PREP"; ui.cls = "bg-info/20 text-info border-info animate-pulse"; 
                ui.timer = formatTime(prepEnd - now); ui.tCls = "text-info"; ui.ind = "bg-info"; 
            } else { 
                ui.badge = "ON AIR"; ui.cls = "bg-danger text-white border-danger animate-blink-soft"; 
                ui.timer = formatTime(s.end_time - now); ui.tCls = "text-white"; ui.ind = "bg-danger"; 
            }
        } else {
            // Upcoming
            const diff = s.start_time - now;
            ui.timer = diff < 86400000 ? formatTime(diff) : new Date(s.start_time).toLocaleDateString([], {day:'2-digit',month:'short'});
            ui.tCls = diff < 86400000 ? "text-primary text-4xl mt-2" : "text-textmuted text-3xl mt-2";
        }

        const badgeHtml = s.display_badge ? `<span class="session-badge">${s.display_badge}</span>` : '';
        const studioName = s.studio_id == 3 ? 'AQUARIUM' : `STUDIO ${s.studio_id}`;

        return `<div onclick="openMonitor(${s.id})" class="bg-bgcard rounded-2xl panel-border p-4 relative cursor-pointer flex flex-col justify-between min-h-[160px]">
            <div class="flex justify-between items-start">
                <div class="flex items-center gap-3">
                    <div class="w-1.5 h-8 rounded-full shadow-lg ${ui.ind}"></div>
                    <div><h3 class="font-display font-bold text-lg text-white leading-none">${studioName}</h3><p class="text-[10px] text-textmuted mt-0.5">${getPhotoType(s.studio_id, s.background)}</p></div>
                </div>
                <span class="px-2 py-0.5 rounded-md text-[10px] font-bold border uppercase ${ui.cls}">${ui.badge}</span>
            </div>
            <div class="text-center my-2"><div class="font-display font-bold leading-none tabular-nums ${ui.tCls === "text-white" || ui.tCls === "text-warning" || ui.tCls.includes("text-") ? "text-5xl" : ui.tCls}">${ui.timer}</div></div>
            <div>
                <div class="flex justify-between items-end mb-2">
                    <div class="truncate max-w-[60%]"><p class="text-[10px] text-textmuted uppercase font-bold mb-0.5">Client</p><p class="font-display font-semibold text-white text-sm truncate flex items-center">${s.customer_name} ${badgeHtml}</p></div>
                    <div class="text-right truncate max-w-[35%]"><p class="text-[10px] text-textmuted uppercase font-bold mb-0.5">Bg</p><p class="font-display font-semibold text-primary text-sm truncate">${s.background}</p></div>
                </div>
                ${pct > 0 ? `<div class="progress-track w-full bg-white/10 h-1 mt-2 rounded-full overflow-hidden"><div class="h-full ${ui.ind} transition-all duration-1000" style="width: ${pct}%"></div></div>` : ''}
            </div>
        </div>`;
    }).join('');
}
// ================= TABLE & HISTORY VIEW =================

// 2. RENDER TABEL UTAMA (Hanya Sesi Aktif)
function renderTable() {
    const tbody = document.getElementById('queue-body'); 
    const now = Date.now();
    
    // Filter: Hanya tampilkan sesi yang BELUM SELESAI
    // Sort: Waktu terdekat di atas
    const list = appState.processedSessions.filter(s => now <= s.end_time); 

    if (list.length === 0) { 
        tbody.innerHTML = `<tr><td colspan="4" class="p-8 text-center text-textmuted text-xs uppercase">Tidak ada sesi aktif</td></tr>`; 
        return; 
    }
    
    tbody.innerHTML = list.map(s => {
        const d = new Date(s.start_time); 
        const prepEnd = s.start_time + (DURATIONS.prep * 60 * 1000);
        
        let statusHtml = '<span class="status-badge badge-wait">WAIT</span>';
        if (now >= s.start_time) statusHtml = now < prepEnd ? '<span class="status-badge badge-prep">PREP</span>' : '<span class="status-badge badge-live">ON AIR</span>';
        
        // Badge 1/2 jika ada
        const badgeHtml = s.display_badge ? `<span class="session-badge">${s.display_badge}</span>` : '';

        return `<tr class="transition border-b border-borderline hover:bg-white/5 cursor-pointer" onclick="openMonitor(${s.id})">
            <td class="p-4"><div class="text-xs font-bold text-white">${d.toLocaleDateString('id-ID',{day:'2-digit',month:'short'})}</div><div class="text-[10px] text-textmuted">${d.toLocaleTimeString([],{hour:'2-digit',minute:'2-digit'})}</div></td>
            <td class="p-4"><div class="font-bold text-white text-sm flex items-center">${s.customer_name} ${badgeHtml}</div><div class="text-[10px] text-textmuted">ST.${s.studio_id}</div></td>
            <td class="p-4 hidden md:table-cell"><span class="bg-pill ${getBgPillClass(s.background)}">${s.background}</span></td>
            <td class="p-4 text-center"><div class="flex items-center justify-center gap-2">${statusHtml}<button onclick="showCustomerQR(${s.id}, event)" class="w-8 h-8 rounded bg-white/10 hover:bg-white/20 text-white flex items-center justify-center"><i class="fa-solid fa-qrcode"></i></button></div></td>
        </tr>`;
    }).join('');
}

// 3. RENDER HISTORY (Hanya Sesi Selesai)
function renderHistory() {
    const tbody = document.getElementById('history-body');
    const empty = document.getElementById('history-empty');
    const now = Date.now();

    // Filter: Hanya yang SUDAH SELESAI
    // Sort: Paling baru selesai di atas (Descending)
    const list = appState.processedSessions.filter(s => now > s.end_time).sort((a,b) => b.end_time - a.end_time);

    if (list.length === 0) { 
        tbody.innerHTML = ""; 
        if(empty) empty.classList.replace('hidden', 'flex'); 
        return; 
    }
    if(empty) empty.classList.replace('flex', 'hidden');

    tbody.innerHTML = list.map(s => {
        const d = new Date(s.start_time);
        const badgeHtml = s.display_badge ? `<span class="session-badge text-textmuted border-textmuted/20">${s.display_badge}</span>` : '';
        
        return `<tr class="transition border-b border-borderline hover:bg-white/5">
            <td class="p-4"><div class="text-xs font-bold text-textmuted">${d.toLocaleDateString('id-ID',{day:'2-digit',month:'short'})}</div><div class="text-[10px] text-textmuted">${d.toLocaleTimeString([],{hour:'2-digit',minute:'2-digit'})}</div></td>
            <td class="p-4"><div class="font-bold text-white text-sm flex items-center">${s.customer_name} ${badgeHtml}</div><div class="text-[10px] text-textmuted">ST.${s.studio_id} • ${s.background}</div></td>
            <td class="p-4 text-right"><button onclick="deleteHistory(${s.id})" class="text-danger hover:text-red-400 text-xs font-bold px-3 py-1 bg-danger/10 rounded"><i class="fa-solid fa-trash"></i></button></td>
        </tr>`;
    }).join('');
}

window.deleteHistory = async function(id) {
    const c = await Swal.fire({title:'Hapus History?', text:'Data tidak bisa kembali.', icon:'warning', showCancelButton:true, confirmButtonColor:'#f87171', background:'#1e293b', color:'#fff'}); 
    if(c.isConfirmed){ await fetch(`${API_URL}?action=delete_session`, {method:'POST',body:JSON.stringify({id})}); fetchSessions(); Swal.fire({icon:'success',title:'Deleted',timer:1000,showConfirmButton:false, background:'#1e293b', color:'#fff'}); } 
};

// 4. RENDER LAYAR MONITOR FULL
function renderFullScreen() {
    if (!appState.monitorSessionId) return;
    const session = appState.processedSessions.find(s => s.id == appState.monitorSessionId); 
    if (!session) { window.toggleMonitor(false); return; }
    
    const now = Date.now(); const prepEnd = session.start_time + (DURATIONS.prep * 60 * 1000);
    const timerEl = document.getElementById('mon-timer'); const glow = document.getElementById('mon-glow'); const btn = document.getElementById('mon-complete-btn-container');
    document.getElementById('mon-cust').innerText = session.customer_name; document.getElementById('mon-bg').innerText = session.background;
    
    if(now < session.start_time) { 
        timerEl.innerText = formatTime(session.start_time - now); timerEl.className = "font-display font-bold text-[100px] md:text-[180px] leading-none tabular-nums text-textmuted"; 
        glow.style.opacity = "0"; btn.classList.add('hidden'); 
    } else if (now < prepEnd) { 
        timerEl.innerText = formatTime(prepEnd - now); timerEl.className = "font-display font-bold text-[100px] md:text-[180px] leading-none tabular-nums text-info drop-shadow-2xl"; 
        glow.className = "absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-info/20 blur-[100px] rounded-full opacity-100"; btn.classList.add('hidden'); 
    } else if (now < session.end_time) { 
        timerEl.innerText = formatTime(session.end_time - now); timerEl.className = "font-display font-bold text-[100px] md:text-[180px] leading-none tabular-nums text-white drop-shadow-2xl"; 
        glow.className = "absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-danger/20 blur-[100px] rounded-full opacity-100"; btn.classList.add('hidden'); 
    } else { 
        timerEl.innerText = "TIME UP"; timerEl.className = "font-display font-bold text-[80px] md:text-[150px] leading-none text-warning tabular-nums"; 
        glow.className = "absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 w-[600px] h-[600px] bg-warning/20 blur-[100px] rounded-full opacity-80"; 
        btn.classList.remove('hidden'); if(Math.floor(now/1000)%2===0) playAlarm(session.studio_id);
    }
    document.getElementById('mon-start').innerText = new Date(session.start_time).toLocaleTimeString([], {hour:'2-digit',minute:'2-digit'}); 
    document.getElementById('mon-end').innerText = new Date(session.end_time).toLocaleTimeString([], {hour:'2-digit',minute:'2-digit'});
}


// ================= QUEUE MANAGER (ANTRIAN) =================

async function fetchQueue() { try { const res = await fetch(`${API_URL}?action=get_queue_list`); const data = await res.json(); renderQueueList(data); } catch(err) { console.error(err); } }

function renderQueueList(list) {
    const container = document.getElementById('print-queue-container'); const empty = document.getElementById('queue-empty-state');
    if (!list || list.length === 0) { container.innerHTML = ''; if(empty) empty.classList.replace('hidden','flex'); return; }
    if(empty) empty.classList.replace('flex','hidden');
    container.innerHTML = list.map(q => {
        let actionBtn = '', statusBadge = '';
        if (q.queue_status === 'waiting') {
            statusBadge = '<span class="bg-warning/10 text-warning px-2 py-1 rounded text-[10px] font-bold uppercase">MENUNGGU</span>';
            actionBtn = `<button onclick="handleQueueAction(${q.id}, 'serving')" class="flex-1 bg-primary hover:bg-sky-500 text-bgmain py-2 rounded-lg font-bold text-xs shadow-lg shadow-primary/20 transition active:scale-95"><i class="fa-solid fa-bullhorn"></i> PANGGIL</button>`;
        } else if (q.queue_status === 'serving') {
            statusBadge = '<span class="bg-success/10 text-success px-2 py-1 rounded text-[10px] font-bold uppercase animate-pulse">DILAYANI</span>';
            actionBtn = `<button onclick="handleQueueAction(${q.id}, 'done')" class="flex-1 bg-success hover:bg-emerald-500 text-bgmain py-2 rounded-lg font-bold text-xs shadow-lg shadow-success/20 transition active:scale-95"><i class="fa-solid fa-check"></i> SELESAI</button>`;
        }
        return `<div class="bg-bgcard border border-borderline rounded-xl p-4 flex justify-between items-center shadow-lg hover:border-primary/30 transition"><div><div class="flex items-center gap-2 mb-1">${statusBadge}<span class="text-[10px] text-textmuted">ST.${q.studio_id}</span></div><div class="flex items-center gap-3"><div class="w-10 h-10 rounded-lg bg-white/5 border border-white/10 flex items-center justify-center font-display font-bold text-xl text-white">${q.queue_number}</div><div><h4 class="font-bold text-white text-sm">${q.customer_name}</h4><p class="text-[10px] text-textmuted">${q.background}</p></div></div></div><div class="w-28 pl-4 border-l border-white/5">${actionBtn}</div></div>`;
    }).join('');
}

async function handleQueueAction(id, status) { try { await fetch(`${API_URL}?action=update_queue_status`, { method: 'POST', body: JSON.stringify({id, status}) }); fetchQueue(); } catch(err) { console.error(err); } }


// ================= UTILITIES & INIT =================

function getBgPillClass(bg) { if(!bg) return 'pill-default'; const l = bg.toLowerCase(); if(l.includes('gray') || l.includes('white')) return 'pill-gray'; if(l.includes('blue')) return 'pill-blue'; if(l.includes('red') || l.includes('pink')) return 'pill-red'; if(l.includes('aqua')) return 'pill-aqua'; return 'pill-default'; }
function getPhotoType(id, bg) { return id==3 ? "Wet Concept" : (bg?.toLowerCase().includes('landscape') ? "Landscape" : "Portrait"); }
function formatTime(ms) { if(ms < 0) return "00:00"; const s = Math.floor(ms/1000); const m = Math.floor(s/60); const sec = s % 60; return `${m}:${sec.toString().padStart(2,'0')}`; }
function playAlarm(id) { if(!appState.alarmEnabled) return; initAudio(); if(audioCtx.state === 'suspended') audioCtx.resume(); const o = audioCtx.createOscillator(); const g = audioCtx.createGain(); o.connect(g); g.connect(audioCtx.destination); o.type = 'sine'; o.frequency.setValueAtTime(800, audioCtx.currentTime); g.gain.setValueAtTime(0.1, audioCtx.currentTime); o.start(); o.stop(audioCtx.currentTime + 0.1); }
window.completeSession = function() { if(audioCtx && audioCtx.state === 'running') audioCtx.suspend(); window.toggleMonitor(false); Swal.fire({icon: 'success', title: 'Sesi Selesai', text: 'Data dipindahkan ke History.', toast: true, position: 'top-end', showConfirmButton: false, timer: 3000, background: '#1e293b', color: '#fff'}); fetchSessions(); };

// --- SYSTEM START ---
document.addEventListener('DOMContentLoaded', () => { 
    // 1. Cek Login (PIN Protection)
    if(localStorage.getItem('skyseven_auth') === 'true') {
        document.getElementById('login-screen').classList.add('hidden');
    }

    // 2. Start Loops
    updateClock(); fetchSessions(); 
    setInterval(updateClock, 1000); 
    setInterval(() => { 
        renderGrid(); // Grid View (dengan Progress Bar)
        renderTable(); // Table View (Active Only)
        renderHistory(); // History View (Done Only)
        if(appState.monitorSessionId) renderFullScreen(); 
    }, 1000); 
    setInterval(fetchQueue, 3000); 
});

// Helper Navigasi
window.switchPage = (pid) => { 
    document.querySelectorAll('.page-view').forEach(e => e.classList.remove('active')); 
    document.getElementById('page-'+pid).classList.add('active'); 
    document.querySelectorAll('.nav-btn').forEach(btn => { 
        if(btn.dataset.target === pid) btn.classList.add('active', 'text-primary'); 
        else btn.classList.remove('active', 'text-primary'); 
    }); 
    if(pid == 'queue') fetchQueue(); 
};

// Modal Helpers
window.toggleSettings = (s) => document.getElementById('modal-settings').classList.toggle('hidden', !s);
window.toggleImport = (s) => document.getElementById('modal-import').classList.toggle('hidden', !s);
window.toggleModal = (s) => { const el=document.getElementById('modal-add'); s?(el.classList.remove('hidden'),window.setNow(),window.updateBgOptions()):el.classList.add('hidden'); };
window.toggleMonitor = (s) => document.getElementById('modal-monitor').classList.toggle('hidden', !s);
window.openMonitor = (id) => { appState.monitorSessionId = id; window.toggleMonitor(true); renderFullScreen(); };
window.toggleEditModal = (s) => document.getElementById('modal-edit').classList.toggle('hidden', !s);
window.setNow = (timeId='inp-time', dateId='inp-date') => { const now=new Date(); document.getElementById(timeId).value=now.toTimeString().substr(0,5); document.getElementById(dateId).value=now.toISOString().split('T')[0]; };
function updateClock() { document.getElementById('nav-clock').innerText = new Date().toLocaleTimeString([], {hour:'2-digit', minute:'2-digit'}); }
